package gov.va.med.mhv.admin.web.validator;

import java.util.ResourceBundle;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "restrictUserValidator")
public class RestrictUserValidator implements Validator {

	//private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String notes = null;
		UIInput notesValue = (UIInput) component.getAttributes().get("notes");

		if (notesValue != null && notesValue.getValue() != null) {
			notes = (String) notesValue.getValue();
		}

		if (notes == null || notes.isEmpty()) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("blockDescRequired"), ""));
		}

	}

}
